
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/date_converter.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/auto_payment/auto_paymet_success_response_model.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/card/cash_2colum.dart';
import 'package:viserpay/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay/view/components/divider/custom_divider.dart';
import 'package:viserpay/view/components/will_pop_widget.dart';
import 'package:viserpay/view/components/dialog/app_dialog.dart';

class SendMoneyAutoPaymentSuccessScreen extends StatefulWidget {
  const SendMoneyAutoPaymentSuccessScreen({super.key});

  @override
  State<SendMoneyAutoPaymentSuccessScreen> createState() => _SendMoneyAutoPaymentSuccessScreenState();
}

class _SendMoneyAutoPaymentSuccessScreenState extends State<SendMoneyAutoPaymentSuccessScreen> {
  AutoPayment? autoPayment;
  bool isLoading = false;
  String currency = "";

  @override
  void initState() {
    MyUtils.allScreen();

    ResponseModel data = Get.arguments[0];
    Get.put(ApiClient(sharedPreferences: Get.find()));
    currency = Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true);

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      setState(() {
        isLoading = true;
      });
      AutoPaymentSuccessResponseModel modal = autoPaymentSuccessResponseModelFromJson(data.responseJson);
      if (modal.status == "success") {
        if (modal.data != null) {
          setState(() {
            autoPayment = modal.data!.autoPayment;
            isLoading = false;
          });
          String date = DateConverter.localNumberDateOnly(modal.data?.autoPayment?.createdAt.toString() ?? "");
          String time = DateConverter.localTimeOnly(modal.data?.autoPayment?.createdAt.toString() ?? "");
          AppDialog().successDialog(
            context,
            willPop: false,
            onTap: () {},
            title: MyStrings.sendMoneyAutoPayment,
            cashDetails: Container(
                padding: const EdgeInsets.all(8),
                decoration: BoxDecoration(
                  border: Border.all(
                    color: MyColor.borderColor,
                  ),
                  borderRadius: BorderRadius.circular(10),
                ),
                child: Stack(
                  children: [
                    Column(
                      children: [
                        IntrinsicHeight(
                          child: CashDetailsColumn(
                            needBorder: false,
                            firstTitle: MyStrings.time.tr,
                            secondTitle: MyStrings.nextAutoPaymentDate.tr,
                            total: "$time $date",
                            newBalance: DateConverter.estimatedDate(autoPayment?.nextPayment ?? DateTime.now()),
                            totalStyle: semiBoldDefault.copyWith(
                              fontWeight: FontWeight.w500,
                              color: MyColor.getTextColor(),
                            ),
                            newBalanceStyle: semiBoldDefault.copyWith(),
                            space: 10,
                          ),
                        ),
                        const CustomDivider(),
                        IntrinsicHeight(
                          child: CashDetailsColumn(
                            needBorder: false,
                            firstTitle: MyStrings.total.tr,
                            secondTitle: MyStrings.type.tr,
                            total: "$currency${StringConverter.formatNumber(autoPayment?.amount.toString() ?? "")}",
                            newBalance: "${autoPayment?.paymentType?.toString().toCapitalized().replaceAll("_", " ")}",
                            space: 10,
                          ),
                        ),
                      ],
                    ),
                  ],
                )),
            userDetails: SizedBox(),
          );
        }
      }
    });
  }

  @override
  void dispose() {
    super.dispose();
    MyUtils.allScreen();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopWidget(
      nextRoute: RouteHelper.bottomNavBar,
      child: Scaffold(
          backgroundColor: MyColor.successBG,
          body: SizedBox(
            // color: MyColor.colorWhite,
            height: MediaQuery.of(context).size.height,
            child: const Center(
              child: CustomLoader(
                isFullScreen: true,
              ),
            ),
          )),
    );
  }
}
